<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use App\Http\Requests\StorePermission;
use App\Http\Requests\UpdatePermission;
use Spatie\Permission\Models\Permission;

class PermissionController extends Controller
{
    public function index()
    {
        if(!auth()->user()->can('view_permission')) {
            abort(403, 'Unauthorized Action');
        }

        return view('dashboards.admins.permission.index');
    }

    public function ssd(Request $request)
    {
        if(!auth()->user()->can('view_permission')) {
            abort(403, 'Unauthorized Action');
        }

        $permission = Permission::query();

        return Datatables::of($permission)
            ->editColumn('updated_at', function($each) {
                return Carbon::parse($each->updated_at)->format('Y-m-d H:i:s');
            })
            ->addColumn('action', function($each) {
                $edit_icon = '<a href="' . route('permission.edit', $each->id) . '" class="text-warning"><i class="far fa-edit"></i></a>';
                $delete_icon = '<a href="#" class="text-danger delete-btn" data-id="'. $each->id .'"><i class="fas fa-trash-alt"></i></a>';

                return '<div class="action-icon">' . $edit_icon . $delete_icon.'</div>';
            })
            ->addColumn('plus-icon', function($each) {
                return null;
            })
            ->rawColumns(['action'])
            ->make(true);
    }

    public function create()
    {
        if(!auth()->user()->can('create_permission')) {
            abort(403, 'Unauthorized Action');
        }

        return view('dashboards.admins.permission.create');
    }

    public function store(StorePermission $request)
    {
        if(!auth()->user()->can('create_permission')) {
            abort(403, 'Unauthorized Action');
        }

        $permission = new Permission();
        $permission->name = $request->name;
        $permission->save();

        return redirect()->route('permission.index')->with('create', 'Permission is successfully Create!');
    }

    public function edit($id)
    {
        if(!auth()->user()->can('edit_permission')) {
            abort(403, 'Unauthorized Action');
        }

        $permission = Permission::findOrFail($id);
        return view('dashboards.admins.permission.edit', compact('permission'));
    }

    public function update($id, UpdatePermission $request)
    {
        if(!auth()->user()->can('edit_permission')) {
            abort(403, 'Unauthorized Action');
        }

        $permission = Permission::findOrFail($id);

        $permission->name = $request->name;
        $permission->update();

        return redirect()->route('permission.index')->with('update', 'Permission is successfully Update!');
    }


    public function destroy($id)
    {
        if(!auth()->user()->can('delete_permission')) {
            abort(403, 'Unauthorized Action');
        }

        $permission = Permission::findOrFail($id);
        $permission->delete();

        return 'success';
    }
}
