<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;

class UserController extends Controller
{
    public function index()
    {

        $users = User::with('roles')->get();
        return view('dashboards.admins.userslist.index', compact('users'));
    }

    public function admin($id){
        $users = Role::find($id);
        return view('dashboards.admins.userslist.adminuser', compact('users'));
    }

    public function edit($id)
    {
        $user = User::find($id);
        $roles = Role::all();
        return view('dashboards.admins.userslist.edit', compact('user', 'roles'));
    }

    public function update(Request $request, $id)
    {
        $user = User::find($id);

        $roleIds = $request->role_id;
        $user->roles()->sync($roleIds);

        return redirect('admin/users');
    }
}
