<?php

namespace App\Http\Controllers\user;

use DB;
use App\Models\Blog;
use App\Models\ServiceA;
use App\Models\BlogCategory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;


class FrontController extends Controller
{
    public function __construct()
	{
		$blogcategories = BlogCategory::all();
        $latestblogs = Blog::with('blogcategories')->orderBy('id', 'DESC')->where('status', '=', 'Public')->take(5)->get();
        $servicea = ServiceA::all();
		view()->share([
			'blogcategories' => $blogcategories,
            'latestblogs' => $latestblogs,
            'servicea' => $servicea,
		]);
	}

    public function index()
    {
    	return view('index');
    }

    public function about()
    {
        return view('about');
    }

    public function contact()
    {
        return view('contact');
    }


}
