<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ServiceA extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'slug',
        'description',
        'address',
        'picture',
        'phone1',
        'phone2',
        'phone3',
        'maplink',
    ];

    public function servicea_path()
    {
        if($this->picture){
            return asset('storage/servicearea/' . $this->picture);
        }

        return null;
    }

    public function plans()
    {
        return $this->hasMany(Plan::class, 'servicea_id', 'id');
    }
}
