 @extends('dashboards.admins.layouts.admin-dash-layout')
@section('title','Dashboard')

@section('content')

<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Dashboard</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Dashboard</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

<!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <div class="row">
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-info">
              <div class="inner">
                <h3>{{ DB::table('lands')->count() }}</h3>

                <p>အိမ်/ခြံ/မြေ</p>
              </div>
              <div class="icon">
                <i class="ion ion-bag"></i>
              </div>
              <a href="{{ route('lands.index')}}" class="small-box-footer">More <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-success">
              <div class="inner">
                <h3>{{ DB::table('kls')->count() }}</h3>

                <p>ဆောင်းပါးအထွေထွေ</p>
              </div>
              <div class="icon">
                <i class="ion ion-stats-bars"></i>
              </div>
              <a href="{{ route('knowledges.index') }}" class="small-box-footer">More <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-danger">
              <div class="inner">
                <h3>{{ DB::table('sds')->count() }}</h3>

                <p>ကုသိုလ်ရေး</p>
              </div>
              <div class="icon">
                <i class="ion ion-pie-graph"></i>
              </div>
              <a href="{{ route('donates.index') }}" class="small-box-footer">More <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-warning">
              <div class="inner">
                <h3>{{ DB::table('users')->count() }}</h3>

                <p>User Registrations</p>
              </div>
              <div class="icon">
                <i class="ion ion-person-add"></i>
              </div>
              <a href="{{url('admin/users')}}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->

        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="card-info">
                    <div class="card-header border-0">
                      <h4 class="card-title" style="font-size: 16px;">နောက်ဆုံးတင်ထားသည့် အိမ်ခြံမြေ</h4>

                    </div>
                    <div class="card-body table-responsive p-0" style="font-size: 14px;">
                      <table class="table table-striped table-valign-middle">
                        <thead>
                        <tr>
                          <th>Code No</th>
                          <th>မြေကွက်အမှတ်</th>
                          <th>မြို့နယ်</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse ($l as $ll)
                        <tr>
                            <td>
                              {{ $ll->code_no }}
                            </td>
                            <td>
                              {!! $ll->ln !!}
                            </td>
                            <td>
                                <i class="fas fa-map-marker"></i>
                                 {{ $ll->ts ? $ll->ts->ts : '_' }}
                            </td>
                          </tr>
                        @empty
                            <tr>
                                No Data Found!
                            </tr>
                        @endforelse

                        </tbody>
                      </table>
                    </div>
                  </div>
                  <!-- /.card -->
            </div>
        </div>
        <br>
        <div class="row">
            <div class="col-lg-6">
                <div class="card-success">
                    <div class="card-header border-0">
                      <h4 class="card-title" style="font-size: 16px;">နောက်ဆုံးတင်ထားသည့် ဆောင်းပါးအထွေထွေ</h4>

                    </div>
                    <div class="card-body table-responsive p-0" style="font-size: 14px;">
                      <table class="table table-bordered table-valign-middle">
                        <thead>
                        <tr>
                          <th>Title</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse ($kl as $k)
                        <tr>
                            <td>
                              {{ $k->title }}
                            </td>

                          </tr>
                        @empty
                            <tr>
                                No Data Found!
                            </tr>
                        @endforelse

                        </tbody>
                      </table>
                    </div>
                  </div>
                  <!-- /.card -->
            </div>
            <div class="col-lg-6">
                <div class="card-danger">
                    <div class="card-header border-0">
                      <h4 class="card-title" style="font-size: 16px;">နောက်ဆုံးတင်ထားသည့် ကုသိုလ်</h4>

                    </div>
                    <div class="card-body table-responsive p-0" style="font-size: 14px;">
                      <table class="table table-bordered table-valign-middle">
                        <thead>
                        <tr>
                          <th>Title</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse ($sd as $d)
                        <tr>
                            <td>
                              {{ $d->title }}
                            </td>

                          </tr>
                        @empty
                            <tr>
                                No Data Found!
                            </tr>
                        @endforelse

                        </tbody>
                      </table>
                    </div>
                  </div>
                  <!-- /.card -->
            </div>
        </div>
        <br>
    </div>
</section>


@endsection

