@extends('dashboards.admins.layouts.admin-dash-layout')
@section('title', 'Plans')

@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h5>Blogs
                        <a href="{{ route('plan.create') }}" class="btn btn-outline-primary btn-sm"><i
                                class="fas fa-plus-circle"></i> Create Plan</a>


                    </h5>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <table class="table table-bordered Datatable" style="width: 100%">
                                <thead>
                                    <th class="text-center no-sort no-search"></th>
                                    <th class="text-center">User ID</th>
                                    <th class="text-center">Plan Name</th>
                                    <th class="text-center">Bandwidth</th>
                                    <th class="text-center">Service Area</th>
                                    <th class="text-center">Content</th>
                                    <th class="text-center">Status</th>
                                    <th class="text-center no-sort no-search">Action</th>
                                    <th class="text-center hidden">Updated at</th>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('scripts')
    <script>
        $(document).ready(function() {
            $('.Datatable').DataTable({
                responsive: true,
                processing: true,
                serverSide: true,
                mark: true,
                ajax: '/admin/plan/datatable/ssd',
                columns: [{
                        data: 'plus-icon',
                        name: 'plus-icon',
                        class: 'text-center'
                    },
                    {
                        data: 'user_id',
                        name: 'user_id',
                        class: 'text-center'
                    },
                    {
                        data: 'plan_name',
                        name: 'plan_name',
                        class: 'text-center'
                    },
                    {
                        data: 'bandwidth',
                        name: 'bandwidth',
                        class: 'text-center'
                    },
                    {
                        data: 'servicearea_name',
                        name: 'servicearea_name',
                        class: 'text-center'
                    },
                    {
                        data: 'description',
                        name: 'description',
                        class: 'text-center'
                    },
                    {
                        data: 'status',
                        name: 'status',
                        class: 'text-center'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        class: 'text-center'
                    },
                    {
                        data: 'updated_at',
                        name: 'updated_at',
                        class: 'text-center'
                    },
                ],
                order: [
                    [8, 'DESC']
                ],
                language: {
                    "paginate": {
                        "previous": "<i class='far fa-arrow-alt-circle-left'></i>",
                        "next": "<i class='far fa-arrow-alt-circle-right'></i>",
                    },
                    "processing": "<img src='/img/slplogo.png' style='width: 150px;'/><p>ခေတ္တစောင့်ဆိုင်းပါ...</p>",
                },
                columnDefs: [{
                        "targets": [0],
                        "class": "control"
                    },
                    {
                        "targets": 'no-sort',
                        "orderable": false
                    },
                    {
                        "targets": 'no-search',
                        "searchable": false
                    },
                    {
                        "targets": 'hidden',
                        "visible": false
                    }
                ],
            });

            $(document).on('click', '.delete-btn', function(e) {
                e.preventDefault();

                var id = $(this).data('id');
                swal({
                        text: "Are you sure you want to delete!",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            $.ajax({
                                method: "DELETE",
                                url: `/admin/plan/${id}`,
                            }).done(function(res) {
                                $('.Datatable').DataTable().ajax.reload();
                            });
                        }
                    });
            });
        })
    </script>

@endsection
