@extends('dashboards.admins.layouts.admin-dash-layout')

@section('title', 'Edit Role')

@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h5>Edit Role</h5>
                </div>

            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form id="edit-form" action="{{ route('role.update', $role->id) }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="md-form">
                                    <label for="">Name</label>
                                    <input type="text" name="name" value="{{ $role->name }}" class="form-control">
                                </div>

                                <label for="">Permissions</label>
                                <div class="row">
                                    @foreach ($permissions as $permission)
                                        <div class="col-md-3 col-6">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" name="permissions[]" class="custom-control-input"
                                                    id="checkbox_{{ $permission->id }}" value="{{ $permission->name }}"
                                                    @if (in_array($permission->id, $old_permissions)) checked @endif>
                                                <label class="custom-control-label"
                                                    for="checkbox_{{ $permission->id }}">{{ $permission->name }}</label>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>

                                <div class="d-flex justify-content-center mt-5 mb-3">
                                    <div class="col-md-6">
                                        <button type="submit" class="btn btn-primary btn-sm btn-block">Comfirm</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('scripts')
    {!! JsValidator::formRequest('App\Http\Requests\UpdateRole', '#edit-form') !!}
    <script>
        $(document).ready(function() {

        });
    </script>

@endsection
