@extends('dashboards.guest.layouts.guest_layout1')

@section('title', 'Blog')

@section('content')


    <!-- ======= Breadcrumbs ======= -->
    <section id="breadcrumbs" class="breadcrumbs">
        <div class="container">

            <ol>
                <li><a href="{{ route('/') }}">Home</a></li>
                <li><a href="{{ route('t-linkblog.index') }}">Blog</a></li>
            </ol>
            <h4>{{ $blog->title }}</h4>

        </div>
    </section><!-- End Breadcrumbs -->

    <div class="container my-3">
        <div class="row t-linkblog">
            <div class="col-md-8">
                <img src="{{ $blog->blogimage_path() }}" alt="" class="img-fluid img-thumbnail">

                <h5 class="mt-2">{{ $blog->title }}</h5>
                <span>
                    <i class="bi bi-person"></i> <a href="#">{{ $blog->user->name }}</a>
                    <i class="bi bi-clock"></i> <a href="#">{{ $blog->created_at->format('j F, Y') }}</a>
                </span>
                <p>{!! $blog->description !!}</p>

                <div class="mb-2">
                    <i class="bi bi-tags"></i>
                    <ul class="tags">
                    @foreach ($blog->blogcategories as $bc)
                        <li><a href="{{ route('t-linkblog.categorybyblog', $bc->slug) }}">{{ $bc->name }}</a></li>
                    @endforeach
                    </ul>
                </div>

            </div>
            <div class="col-md-4">
                <div class="sidebar">

                    <h3 class="sidebar-title">Search</h3>
                    <div class="sidebar-item search-form">
                        <form action="{{ route('t-linkblog.search') }}" method="post">
                            @csrf
                            <input type="text" name="s">
                            <button type="submit"><i class="bi bi-search"></i></button>
                        </form>
                    </div><!-- End sidebar search formn-->

                    <h3 class="sidebar-title">Categories</h3>
                    <div class="sidebar-item categories">
                        <ul>
                            @forelse ($blogcategories as $bc)
                                @if ($bc->blogs->count() == 0)
                                @else
                                    <li><a href="{{ route('t-linkblog.categorybyblog', $bc->slug) }}">{{ $bc->name }} <span>({{ $bc->blogs()->count() }})</span></a>
                                    </li>
                                @endif
                            @empty
                                <li>No Category Found!</li>
                            @endforelse

                        </ul>
                    </div><!-- End sidebar categories-->

                    <h3 class="sidebar-title">Recent Posts</h3>
                    <div class="sidebar-item recent-posts">
                        @forelse ($latestblogs as $lblog)
                            <div class="post-item clearfix">
                                <img src="{{ $lblog->blogimage_path() }}" alt="" class="img-fluid">
                                <h4><a href="{{ route('t-linkblog.show', $lblog->slug) }}">{{ $lblog->title }}</a></h4>
                                <time datetime="2020-01-01">Jan 1, 2020</time>
                            </div>
                        @empty
                            <p>No Latest Blog found!</p>
                        @endforelse

                    </div><!-- End sidebar recent posts-->

                </div><!-- End sidebar -->
            </div>
        </div>
    </div>

@endsection
