<?php $__env->startSection('title', 'အိမ်ခြံမြေ'); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        input[type="file"] {
            display: block;
        }

        .imageThumb {
            max-height: 75px;
            border: 2px solid;
            padding: 1px;
            cursor: pointer;
        }

        .pip {
            display: inline-block;
            margin: 10px 10px 0 0;
        }

        .img-delete {
            display: block;
            background: #444;
            border: 1px solid black;
            color: white;
            text-align: center;
            cursor: pointer;
        }

        .img-delete:hover {
            background: white;
            color: black;
        }

    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h5>အိမ်ခြံမြေ အချက်အလက်များ ပြင်ဆင်ရန်</h5>
                </div>

            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <!-- <div class="card-header">
                        <h3 class="card-title">DataTable with default features</h3>
                    </div> -->
                        <!-- /.card-header -->
                        <div class="card-body">
                            <form method="post" id="land-update" action="<?php echo e(route('lands.update', $land->id)); ?>"
                                enctype="multipart/form-data">
                                <?php echo method_field('PUT'); ?>
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌Code_No.</label> <span style="color: red;">*</span>
                                            <input type="text" name="code_no" class="form-control"
                                                value="<?php echo e($land->code_no); ?>">
                                        </div>

                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌တန်ဖိုး</label> <span style="color: red;">*</span>
                                            <input type="text" name="price" class="form-control"
                                                value="<?php echo e($land->price); ?>">
                                        </div>

                                    </div>
                                    <div class="col-md-12">

                                        <div class="form-group">
                                            <label>‌တန်ဖိုးရွေးချယ်ရန်</label> <span style="color: red;">*</span>
                                            <select id="mySelect2" class="form-control" name="pl_id">

                                                <?php $__currentLoopData = App\Models\Pl::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($cat->id == $land->pl_id): ?>
                                                        <option value='<?php echo e($cat->id); ?>' selected="">
                                                            <?php echo e($cat->pl); ?></option>
                                                    <?php else: ?>
                                                        <option value='<?php echo e($cat->id); ?>'><?php echo e($cat->pl); ?></option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <input type="hidden" name="recommand" value="0">
                                            <input type="checkbox" name="recommand" value="1"
                                                <?php echo e($land->recommand || old('recommand', 0) === 1 ? 'checked' : 'unchecked'); ?>>
                                            <label class="form-check-label" for="recommand">‌အကြံပြု</label>
                                        </div>

                                    </div>
                                    <div class="col-md-12">

                                        <div class="form-group">
                                            <label>‌မြေပိုင်ဆိုင်မှုအထောက်အထား</label> <span style="color: red;">*</span>
                                            <select id="mySelect2" class="form-control" name="lt_id">

                                                <?php $__currentLoopData = App\Models\Lt::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($cat->id == $land->lt_id): ?>
                                                        <option value='<?php echo e($cat->id); ?>' selected="">
                                                            <?php echo e($cat->land_type); ?></option>
                                                    <?php else: ?>
                                                        <option value='<?php echo e($cat->id); ?>'><?php echo e($cat->land_type); ?>

                                                        </option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌ရောင်း/ငှား</label> <span style="color: red;">*</span>
                                            <select id="mySelect2" class="form-control" name="sr_id">
                                                <?php $__currentLoopData = App\Models\Sr::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($cat->id == $land->sr_id): ?>
                                                        <option value='<?php echo e($cat->id); ?>' selected="">
                                                            <?php echo e($cat->sr); ?>

                                                        </option>
                                                    <?php else: ?>
                                                        <option value='<?php echo e($cat->id); ?>'><?php echo e($cat->sr); ?></option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌မြို့နယ်</label> <span style="color: red;">*</span>
                                            <select id="mySelect2" class="form-control" name="ts_id">
                                                <?php $__currentLoopData = App\Models\Ts::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($cat->id == $land->ts_id): ?>
                                                        <option value='<?php echo e($cat->id); ?>' selected="">
                                                            <?php echo e($cat->ts); ?></option>
                                                    <?php else: ?>
                                                        <option value='<?php echo e($cat->id); ?>'><?php echo e($cat->ts); ?></option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌အရပ်လှည့်</label> <span style="color: red;">*</span>
                                            <select id="mySelect2" class="form-control" name="lta_id">
                                                <?php $__currentLoopData = App\Models\Lta::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($cat->id == $land->lta_id): ?>
                                                        <option value='<?php echo e($cat->id); ?>' selected="">
                                                            <?php echo e($cat->lta); ?></option>
                                                    <?php else: ?>
                                                        <option value='<?php echo e($cat->id); ?>'><?php echo e($cat->lta); ?></option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌မြေကွက်အမှတ်/လမ်းအမည်အပြည့်အစုံ</label>
                                            <textarea name="ln" class="form-control">
                                    <?php echo $land->ln; ?>

                              </textarea>
                                        </div>

                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌အကျယ်အဝန်း</label> <span style="color: red;">*</span>
                                            <select id="mySelect2" class="form-control" name="la_id">
                                                <?php $__currentLoopData = App\Models\La::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($cat->id == $land->la_id): ?>
                                                        <option value='<?php echo e($cat->id); ?>' selected="">
                                                            <?php echo e($cat->la); ?></option>
                                                    <?php else: ?>
                                                        <option value='<?php echo e($cat->id); ?>'><?php echo e($cat->la); ?></option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌မြေပိုရှိ/မရှိ</label>
                                            <input type="text" name="ml" value="<?php echo e($land->ml); ?>"
                                                class="form-control">
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌ခြံစည်းရိုးကာရံထားမှုအခြေအနေ</label>
                                            <textarea name="lfc" class="form-control">
                                    <?php echo $land->lfc; ?>

                              </textarea>
                                        </div>

                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌တည်နေရာ ရှေ့နောက်ဘေးတည်ရှိမှုနှင့် လူနေထိုင်မှုအခြေအနေ</label>
                                            <textarea name="llc" class="form-control">
                                    <?php echo $land->llc; ?>

                              </textarea>
                                        </div>

                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌လမ်းအကျယ်နှင့် မော်တော်ယာဉ်ဝင်ရောက်နိုင်မှုအခြေအနေ</label>
                                            <textarea name="lwc" class="form-control">
                                    <?php echo $land->lwc; ?>

                              </textarea>
                                        </div>

                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌အဆောက်အဦ အမျိုးအစား၊ အခန်းဖွဲ့စည်းပုံ အကျယ်အဝန်း</label>
                                            <textarea name="bt" class="form-control">
                                    <?php echo $land->bt; ?>

                              </textarea>
                                        </div>

                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌ရေ(စည်ပင်ရေ/အဝီစိတွင်းရေ)</label>
                                            <input type="text" name="wc" value="<?php echo e($land->wc); ?>"
                                                class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌မီး (မီတာ) ရှိ/မရှိ</label>
                                            <input type="text" name="ec" value="<?php echo e($land->ec); ?>"
                                                class="form-control">
                                        </div>
                                    </div>


                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌အိမ်ထောင်ပရိဘောဂပစ္စည်းပါ/မပါ</label>
                                            <input type="text" name="fc" value="<?php echo e($land->fc); ?>"
                                                class="form-control">
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌အနီးပါတ်ဝန်းကျင်ရှိ နောက်ဆုံးကာလပေါက်ဈေး</label>
                                            <input type="text" name="np" value="<?php echo e($land->np); ?>"
                                                class="form-control">
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌အနီးပတ်ဝန်းကျင် ဘုရား၊ ကျောင်း၊ ဈေး၊ ဘဏ်၊ ဆေးရုံ၊ ဆေးခန်း၊ ရဲစခန်း၊
                                                မီးသတ်ရှိ/မရှိ</label>
                                            <textarea name="lnc" class="form-control">
                                    <?php echo $land->lnc; ?>

                              </textarea>
                                        </div>

                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌အိမ်ခြံမြေငှားရမ်းရာတွင် ရရှိနိုင်မည့် (ခန့်မှန်း)ဈေးနှုန်း</label>
                                            <input type="text" name="rp" value="<?php echo e($land->rp); ?>"
                                                class="form-control">
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select class="form-control" name="status">
                                                <option><?php echo e($land->status); ?></option>
                                                <?php if($land->status == 'Draft'): ?>
                                                    <option>Public</option>
                                                <?php else: ?>
                                                    <option>Draft</option>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>‌အခြားဖြည့်စွက်ချက်များ</label>
                                            <textarea name="of" class="form-control">
                                    <?php echo $land->of; ?>

                              </textarea>
                                        </div>

                                    </div>

                                    <div class="col-md-12 mb-5">
                                        <?php $__currentLoopData = $land->landimages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(asset('/landimages/' . $k->images)); ?>"
                                                data-lightbox="image-group-1" data-title="<?php echo e($k->images); ?>">
                                                <img class="img-thumbnail"
                                                    src="<?php echo e(asset('/landimages/' . $k->images)); ?>"
                                                    style="max-height: 100px; max-width: 100px; margin: 3px;">

                                            </a>
                                            <a href="#" id="del" data-id="<?php echo e($k->id); ?>" data-toggle="tooltip"
                                                title="Remove" data-placement="bottom"
                                                style="position: absolute; margin-left: -50px;">
                                                <i class="fas fa-times-circle ml-4 text-danger"
                                                    style="font-size: 1.5em;"></i>
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>

                                    <div class="col-md-12 mb-5">
                                        <p><label for="multiple_files" style="cursor: pointer;"
                                                class="btn btn-warning">Upload Images</label></p>
                                        <input type="file" style="display: none;" id="multiple_files" name="images[]"
                                            multiple />
                                    </div>

                                    <div class="col-md-12">
                                        <input class="btn btn-primary btn-sm" type="submit"
                                            value="အိမ်ခြံမြေအချက်အလက်ပြင်ဆင်ရန်">

                                    </div>

                                </div>
                            </form>

                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo JsValidator::formRequest('App\Http\Requests\UpdateLand', '#land-update'); ?>

    <script src="<?php echo e(asset('ckeditor/ckeditor.js')); ?>"></script>
    <script>
        let tg = [{
                name: 'document',
                groups: ['mode', 'document', 'doctools']
            },
            {
                name: 'clipboard',
                groups: ['clipboard', 'undo']
            },

            {
                name: 'basicstyles',
                groups: ['basicstyles', 'cleanup']
            },
            {
                name: 'paragraph',
                groups: ['list', 'indent', 'blocks', 'align', 'bidi']
            },
            {
                name: 'links'
            },
            '/',
            {
                name: 'styles'
            },
            {
                name: 'colors'
            },
            {
                name: 'tools'
            },
            {
                name: 'others'
            }
        ];

        CKEDITOR.replace('ln', {
            toolbarGroups: tg
        });
        CKEDITOR.replace('lfc', {
            toolbarGroups: tg
        });
        CKEDITOR.replace('llc', {
            toolbarGroups: tg
        });
        CKEDITOR.replace('lwc', {
            toolbarGroups: tg
        });
        CKEDITOR.replace('bt', {
            toolbarGroups: tg
        });
        CKEDITOR.replace('lnc', {
            toolbarGroups: tg
        });
        CKEDITOR.replace('of', {
            toolbarGroups: tg
        });
    </script>
    <script>
        $(document).ready(function() {
            if (window.File && window.FileList && window.FileReader) {
                $("#multiple_files").on("change", function(e) {
                    var multiple_files = e.target.files,
                        filesLength = multiple_files.length;
                    for (var i = 0; i < filesLength; i++) {
                        var f = multiple_files[i]
                        var fileReader = new FileReader();
                        fileReader.onload = (function(e) {
                            var file = e.target;
                            $("<span class=\"pip\">" +
                                "<img class=\"imageThumb\" src=\"" + e.target.result +
                                "\" title=\"" + file.name + "\"/>" +
                                "<br/><span class=\"img-delete\">Remove</span>" +
                                "</span>").insertAfter("#multiple_files");
                            $(".img-delete").click(function() {
                                $(this).parent(".pip").remove();
                            });
                        });
                        fileReader.readAsDataURL(f);
                    }
                });
            } else {
                alert("|Sorry, | Your browser doesn't support to File API")
            }
        });
    </script>

    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $(function() {

            /* UPDATE ADMIN PERSONAL INFO */

            $('#land-update').on('submit', function(e) {
                e.preventDefault();
                CKEDITOR.instances.ln.updateElement();
                CKEDITOR.instances.lfc.updateElement();
                CKEDITOR.instances.llc.updateElement();
                CKEDITOR.instances.lwc.updateElement();
                CKEDITOR.instances.bt.updateElement();
                CKEDITOR.instances.lnc.updateElement();
                CKEDITOR.instances.of.updateElement();
                $.ajax({
                    url: $(this).attr('action'),
                    method: $(this).attr('method'),
                    data: new FormData(this),
                    processData: false,
                    dataType: 'json',
                    contentType: false,
                    beforeSend: function() {
                        $(document).find('span.error-text').text('');
                        Swal.fire({
                            title: 'ခေတ္တစောင့်ဆိုင်းပေးပါ !',
                            html: 'အချက်အလက်များ ပြင်ဆင်နေပါသည် !', // add html attribute if you want or remove
                            allowOutsideClick: false,
                            onBeforeOpen: () => {
                                Swal.showLoading()
                            },
                        });
                    },
                    success: function(data) {
                        if (data.status == 0) {
                            $.each(data.error, function(prefix, val) {
                                $('span.' + prefix + '_error').text(val[0]);
                            });
                        } else {
                            Swal.close();
                            swal("Good job!", "You clicked the button!", "success")
                                .then(function() {
                                    location.reload();
                                });
                            // $('#room-create').trigger('reset');

                        }
                    }
                });
            });

        });

        // delete images file
        $('body').delegate('#del', 'click', function(e) {
            var id = $(this).data('id');
            if (confirm("Are You Sure Want To Delete?")) {
                $.post('<?php echo e(URL::to('admin/landimages/delete')); ?>', {
                    id: id
                }, function(data) {
                    $('tr#' + id).remove();
                    swal({
                        position: 'top-end',
                        type: 'success',
                        title: 'Successfully Deleted!',
                        showConfirmButton: false,
                        timer: 3000
                    })

                    location.reload();
                })
            }

        })
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboards.admins.layouts.admin-dash-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\su\resources\views/dashboards/admins/lands/edit.blade.php ENDPATH**/ ?>