<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>ဆုလာဒ်ပိုင် | <?php echo $__env->yieldContent('title'); ?></title>
    <!-- <base href="<?php echo e(\URL::to('/')); ?>"> -->
    <link rel="shortcut icon" href="<?php echo e(asset('img/favicon.png')); ?>">


    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="<?php echo e(asset('back/plugins/fontawesome-free/css/all.min.css')); ?>">
    <!-- DataTables -->
    <link rel="stylesheet" href="<?php echo e(asset('back/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('back/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('back/plugins/datatables-buttons/css/buttons.bootstrap4.min.css')); ?>">
    <!-- /DataTables -->
    <link rel="stylesheet" href="<?php echo e(asset('back/plugins/ijaboCropTool/ijaboCropTool.min.css')); ?>">
    <!-- sweetalert2 -->
    <link rel="stylesheet" href="<?php echo e(asset('back/plugins/sweetalert2/sweetalert2.min.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('back/plugins/daterangepicker/daterangepicker.css')); ?>">
    <!-- light box css -->
    <link rel="stylesheet" href="<?php echo e(asset('back/plugins/lightbox/css/lightbox.min.css')); ?>">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo e(asset('back/dist/css/adminlte.min.css')); ?>">
    <link href="<?php echo e(asset('css/select2.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/admincustom.css')); ?>" rel="stylesheet">
    <style>
        @font-face {
            font-family: Pyidaungsu;
            src: url('/fonts/Pyidaungsu.eot');
            src: local('☺'), url('/fonts/Pyidaungsu.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
        }

        .tagu {
            font-family: "Pyidaungsu" !important;
        }

        label:not(.form-check-label):not(.custom-file-label) {
            font-weight: normal;
        }

        .nav-icon {
            color: #96ed90;
        }

        /* -----------------action icon ---------------*/
        .action-icon a {
            padding: 5px;
            background-color: #eee;
            border-radius: 5px;
            width: 32px;
            height: 32px;
            line-height: 25px;
            display: inline-block;
            margin: 3px !important;
        }

        /*-----------preview image -----------------*/
        .preview_img img {
            width: 100px;
            border-radius: 5px;
            border: 1px solid #ddd;
        }

        .profile-img {
            width: 100px;
            height: 100px;
            border-radius: 100%;
            border: 1px solid #5cb85c;
            padding: 3px;
        }

        .profile-thumbnail {
            width: 70px;
            height: 70px;
            border-radius: 10px;
            border: 1px solid #ddd;
            padding: 3px;
        }

        .dash-border {
            border-left: 2px dotted #ddd;
        }

        .nav-link p, .sidebar .user-panel .info {
            transition: margin-left .3s linear,opacity .3s ease,visibility .3s ease;
            font-size: 14px;
          }

    </style>
    <?php echo $__env->yieldContent('styles'); ?>

</head>

<body class="hold-transition sidebar-mini layout-fixed tagu">
    <div class="wrapper">

        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">
            <!-- Left navbar links -->
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i
                            class="fas fa-bars"></i></a>
                </li>

                <li class="nav-item d-none d-sm-inline-block">
                    <a target="_blank" class="nav-link" href="<?php echo e(route('/')); ?>"
                        class="nav-link <?php echo e(request()->is('/') ? 'active' : ''); ?>">
                        Visit Site
                    </a>
                </li>

                

                <li class="nav-item d-none d-sm-inline-block">
                    <a class="nav-link" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
          document.getElementById('logout-form').submit();">
                        <?php echo e(__('Logout')); ?>

                    </a>

                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                        <?php echo csrf_field(); ?>
                    </form>
                </li>
            </ul>


        </nav>
        <!-- /.navbar -->

        <!-- Main Sidebar Container -->
        <aside class="main-sidebar sidebar-dark-primary elevation-4">
            <!-- Brand Logo -->
            <a href="<?php echo e(route('/')); ?>" class="brand-link">
                <img src="<?php echo e(asset('img/slplogo.png')); ?>" alt="AdminLTE Logo" class="brand-image elevation-3"
                    style="opacity: .8">
                <span class="brand-text"><strong style="color: gold;">ဆုလာဒ်ပိုင်</strong></span>
            </a>

            <!-- Sidebar -->
            <div class="sidebar">
                <!-- Sidebar user panel (optional) -->
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        <img src="<?php echo e(Auth::user()->profile_img_path()); ?>" class="img-circle elevation-2 admin_picture"
                            alt="User Image">
                    </div>
                    <div class="info">
                        <a href="#" class="d-block admin_name"><?php echo e(Auth::user()->name); ?></a>
                    </div>
                </div>



                <!-- Sidebar Menu -->
                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">

                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.dashboard')); ?>"
                                class="nav-link <?php echo e(set_active(['admin.dashboard'])); ?>">
                                <i class="nav-icon fas fa-tachometer-alt"></i>
                                <p>
                                    Dashboard
                                </p>
                            </a>
                        </li>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_user')): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('employee.index')); ?>"
                                    class="nav-link <?php echo e(set_active(['employee.index'])); ?>">
                                    <i class="nav-icon fas fa-users"></i>
                                    <p>
                                        Users
                                    </p>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_role')): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('role.index')); ?>" class="nav-link <?php echo e(set_active(['role.index'])); ?>">
                                    <i class="nav-icon fas fa-user-shield"></i>
                                    <p>
                                        Roles
                                    </p>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_permission')): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('permission.index')); ?>"
                                    class="nav-link <?php echo e(set_active(['permission.index'])); ?>">
                                    <i class="nav-icon fas fa-shield-alt"></i>
                                    <p>
                                        Permissions
                                    </p>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_အိမ်ခြံမြေ')): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('lands.index')); ?>" class="nav-link">
                                    
                                    <i class="nav-icon fas fa-home"></i>
                                    <p>
                                        အိမ်/ခြံ/မြေ
                                    </p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_မြေအမျိုးအစား')): ?>
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="nav-icon fas fa-laptop-house"></i>
                                    <p>
                                        မြေကွက်ဆိုင်ရာများ
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>
                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="<?php echo e(url('admin/viewLt')); ?>" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>မြေအမျိုးအစား</p>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="<?php echo e(url('admin/viewLta')); ?>" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>အရပ်လှည့်</p>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="<?php echo e(url('admin/viewLa')); ?>" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>အကျယ်အဝန်း</p>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="<?php echo e(url('admin/viewTs')); ?>" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>မြို့နယ်</p>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="<?php echo e(url('admin/viewPl')); ?>" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>တန်ဖိုး</p>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_ဆောင်းပါး')): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(url('admin/knowledges')); ?>" class="nav-link">
                                    <i class="nav-icon fas fa-newspaper"></i>
                                    <p>
                                        ဆောင်းပါးအထွေထွေ
                                    </p>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_ဆောင်းပါးအမျိုးအစား')): ?>
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="nav-icon far fa-newspaper"></i>
                                    <p>
                                        ဆောင်းပါဆိုင်ရာများ
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>
                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="<?php echo e(url('admin/viewKc')); ?>" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>ဆောင်းပါးအမျိုးအစား</p>
                                        </a>
                                    </li>

                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_ကုသိုလ်ရေး')): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(url('admin/donates')); ?>" class="nav-link">
                                    
                                    <i class="nav-icon fas fa-hand-holding-usd"></i>
                                    <p>
                                        ကုသိုလ်ရေး
                                    </p>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_ကုသိုလ်ပြုနေရာ')): ?>
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="nav-icon fas fa-donate"></i>
                                    <p>
                                        ကုသိုလ်ရေးဆိုင်ရာများ
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>
                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="<?php echo e(url('admin/viewDc')); ?>" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>ကုသိုလ်ပြုနေရာ</p>
                                        </a>
                                    </li>

                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_profile')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.profile')); ?>"
                                class="nav-link <?php echo e(set_active(['admin.profile'])); ?>">
                                <i class="nav-icon far fa-address-card"></i>
                                <p>
                                    Profile
                                </p>
                            </a>
                        </li>
                        <?php endif; ?>
                        <!--  <li class="nav-item">
          <a href="<?php echo e(route('admin.settings')); ?>" class="nav-link <?php echo e(request()->is('admin/settings*') ? 'active' : ''); ?>">
            <i class="nav-icon fas fa-cog"></i>
            <p>
             Logout
           </p>
         </a>
       </li> -->
                    </ul>
                </nav>
                <!-- /.sidebar-menu -->
            </div>
            <!-- /.sidebar -->
        </aside>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
        <!-- /.content-wrapper -->

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
            <div class="p-3">
                <h5>Title</h5>
                <p>Sidebar content</p>
            </div>
        </aside>
        <!-- /.control-sidebar -->

        <!-- Main Footer -->
        <footer class="main-footer">
            <!-- To the right -->
            <div class="float-right d-none d-sm-inline">
                Anything you want
            </div>
            <!-- Default to the left -->
            <strong>Copyright &copy; <?php echo e(date('Y')); ?> <a href="<?php echo e(route('/')); ?>">SuLatPaing
                    Co.,Ltd.</a>.</strong> All rights reserved.
        </footer>
    </div>
    <!-- ./wrapper -->

    <!-- REQUIRED SCRIPTS -->

    <!-- jQuery -->
    <script src="<?php echo e(asset('back/plugins/jquery/jquery.min.js')); ?>"></script>
    <!-- Bootstrap 4 -->
    <script src="<?php echo e(asset('back/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <!-- lightbox JS -->
    <script src="<?php echo e(asset('back/plugins/lightbox/js/lightbox-plus-jquery.min.js')); ?>"></script>
    <!-- DataTables  & Plugins -->
    <script src="<?php echo e(asset('back/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('back/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('back/plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('back/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('back/plugins/datatables-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('back/plugins/datatables-buttons/js/buttons.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('back/plugins/jszip/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('back/plugins/pdfmake/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('back/plugins/pdfmake/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('back/plugins/datatables-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('back/plugins/datatables-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('back/plugins/datatables-buttons/js/buttons.colVis.min.js')); ?>"></script>
    <!-- /DataTables -->
    <script src="<?php echo e(asset('back/plugins/ijaboCropTool/ijaboCropTool.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/sweetalert2.min.js')); ?>"></script>
    
    <script type="text/javascript" src="<?php echo e(asset('back/plugins/daterangepicker/moment.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('back/plugins/daterangepicker/daterangepicker.js')); ?>"></script>
    
    <script src="<?php echo e(asset('js/sweetalert1.min.js')); ?>"></script>
    <!-- ChartJS -->
    <script src="<?php echo e(asset('back/plugins/chart.js/Chart.min.js')); ?>"></script>

    <!-- AdminLTE App -->
    <script src="<?php echo e(asset('back/dist/js/adminlte.min.js')); ?>"></script>
    <!-- Laravel Javascript Validation -->
    <script type="text/javascript" src="<?php echo e(url('vendor/jsvalidation/js/jsvalidation.js')); ?>"></script>

    <!-- AdminLTE App -->
    <script src="<?php echo e(asset('js/select2.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/script.js')); ?>"></script>

    <?php echo $__env->yieldContent('scripts'); ?>
    
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $(function() {

            /* UPDATE ADMIN PERSONAL INFO */

            $('#AdminInfoForm').on('submit', function(e) {
                e.preventDefault();

                $.ajax({
                    url: $(this).attr('action'),
                    method: $(this).attr('method'),
                    data: new FormData(this),
                    processData: false,
                    dataType: 'json',
                    contentType: false,
                    beforeSend: function() {
                        $(document).find('span.error-text').text('');
                    },
                    success: function(data) {
                        if (data.status == 0) {
                            $.each(data.error, function(prefix, val) {
                                $('span.' + prefix + '_error').text(val[0]);
                            });
                        } else {
                            $('.admin_name').each(function() {
                                $(this).html($('#AdminInfoForm').find($(
                                    'input[name="name"]')).val());
                            });
                            swal("Good job!", "You clicked the button!", "success")

                            .then(function() {
                                location.reload();
                            });
                                        }
                    }
                });
            });



            $(document).on('click', '#change_picture_btn', function() {
                $('#admin_image').click();
            });


            $('#admin_image').ijaboCropTool({
                preview: '.admin_picture',
                setRatio: 1,
                allowedExtensions: ['jpg', 'jpeg', 'png'],
                buttonsText: ['CROP', 'QUIT'],
                buttonsColor: ['#30bf7d', '#ee5155', -15],
                processUrl: '<?php echo e(route('adminPictureUpdate')); ?>',
                // withCSRF:['_token','<?php echo e(csrf_token()); ?>'],
                onSuccess: function(message, element, status) {
                    swal("Good job!", "You clicked the button!", "success")

                    .then(function() {
                        location.reload();
                    });
                },
                onError: function(message, element, status) {
                    alert(message);
                }
            });


            $('#changePasswordAdminForm').on('submit', function(e) {
                e.preventDefault();

                $.ajax({
                    url: $(this).attr('action'),
                    method: $(this).attr('method'),
                    data: new FormData(this),
                    processData: false,
                    dataType: 'json',
                    contentType: false,
                    beforeSend: function() {
                        $(document).find('span.error-text').text('');
                    },
                    success: function(data) {
                        if (data.status == 0) {
                            $.each(data.error, function(prefix, val) {
                                $('span.' + prefix + '_error').text(val[0]);
                            });
                        } else {
                            $('#changePasswordAdminForm')[0].reset();
                            swal("Good job!", "You clicked the button!", "success")

                            .then(function() {
                                location.reload();
                            });
                        }
                    }
                });
            });

            <?php if(session('create')): ?>
                Swal.fire({
                    title: 'Successfully Created!',
                    text: '<?php echo e(session('create')); ?>',
                    icon: 'success',
                })
            <?php endif; ?>

            <?php if(session('update')): ?>
                Swal.fire({
                    title: 'Successfully Updated!',
                    text: '<?php echo e(session('update')); ?>',
                    icon: 'success',
                })
            <?php endif; ?>

            $('.select-ninja').select2();
        });
    </script>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\su\resources\views/dashboards/admins/layouts/admin-dash-layout.blade.php ENDPATH**/ ?>